<?php
/**
 *
 * @package	    Pay My Bill Module
 * @subpackage	Pay My Bill Module
 * @version     1.0.0
 * @description Pay My Bill Module
 * @copyright	  Copyright © 2013 - All rights reserved.
 * @license		  GNU General Public License v2.0
 * @author		  SoftPill.Eu
 * @author mail	mail@softpill.eu
 * @website		  www.softpill.eu
 *
 */
//ini_set("display_errors",0);
//error_reporting(E_ALL);
class PMBpayupoland
{
  function checkMethod($params)
  {
    $vendor_missing=JText::_( 'PMB_PAYUPOLAND_MODULE_ERR_VENDOR' );
    $password_missing=JText::_( 'PMB_PAYUPOLAND_MODULE_ERR_PASS' );
    $password2_missing=JText::_( 'PMB_PAYUPOLAND_MODULE_ERR_PASS2' );
    $vendor_name=trim($params->get('payupoland_user'));
    $vendor_password=trim($params->get('payupoland_password'));
    $vendor_password2=trim($params->get('payupoland_password2'));
    if($vendor_name=='')
    {
      ?>
        <div class="pmb_error"><?php echo $vendor_missing;?></div>
      <?php
      return false;
    }
    else if($vendor_password=='')
    {
      ?>
        <div class="pmb_error"><?php echo $password_missing;?></div>
      <?php
      return false;
    }
    else if($vendor_password2=='')
    {
      ?>
        <div class="pmb_error"><?php echo $password2_missing;?></div>
      <?php
      return false;
    }
    return true;
  }
  function getPMBDomain()
  {
    $domain=str_ireplace("www.","",$_SERVER['HTTP_HOST']);
    $is_ip = ip2long($domain) !== false;
    if($is_ip)
    {
      return false;
    }
    else if(trim($domain)=='')
    {
      return false;
    }
    
    return $domain;
  }
  function doPayment($params,$details,$all_params)
  {
    /**/
    $dchk=$all_params['dchk'];
    $lic=$all_params['pmblic'];
    $the_domain=$this->getPMBDomain();
    if($the_domain)
    {
      $chk=md5($lic.$the_domain);
      if($dchk!=$chk)
      {
        echo '<font color="red"><strong>'.JText::_( 'PMB_MODULE_LICENSE_ERR' ).'</strong></font>';
        exit;
      }
    }
    
    $product_name=$params->get('product_name');
    $invoice_field=$params->get('show_inv_field');
    $cost_per_transaction=$params->get('payupoland_trans_cost')+0;
    $percent_per_transaction=$params->get('payupoland_trans_percent_cost')+0;
    
    $vendor_name=trim($params->get('payupoland_user'));
    $vendor_password=trim($params->get('payupoland_password'));
    $vendor_password2=trim($params->get('payupoland_password2'));
    $language=$params->get('payupoland_language');
    $mode=$params->get('payupoland_mode');
    $currency=$params->get('payupoland_currency');
    
    $details['subtotal']=$details['payment'];
    $payment=$details['payment'];
    if($cost_per_transaction>0)
    {
      $payment+=$cost_per_transaction;
    }
    if($percent_per_transaction>0)
    {
      $payment=$payment+($payment*$percent_per_transaction);
    }
    
    $payment=round($payment,2);
    $payment=number_format($payment,2);
    $details['payment']=$payment;
    $details['mode']=$mode;
    $details['currency']=$currency;
    if($params->get('mail_pending')!=0)
    {
      require_once(JPATH_BASE.DS."modules".DS."mod_paymybill".DS."functions".DS."functions.php");
      $pmbf=new PMBFunctions();
      $pmbf->sendConfirmationMail("pending",$all_params,$details,'PayuPoland');//send pending mail
    }
    $pmbf->saveOrder($payment,$mode,$all_params,$details,'PayuPoland');
    
    $languageCode=strtolower($language);
    if($languageCode!='en' && $languageCode!='pl')
    {
      $languageCode='en';
    }
    $PaymentDescription=$product_name.' at '.$_SERVER['HTTP_HOST'].' order.';
    
    if($invoice_field)
    {
      $PaymentDescription=$product_name.' at '.$_SERVER['HTTP_HOST'].' for '.$details['InvNr'];
    }
    
    $stamp=time();
    $amount=number_format(round($payment,2),2)*100;
    $sig=md5 ($vendor_name.$details['order_id'].$vendor_password2.
    $amount.$PaymentDescription.$details['BillFname'].$details['BillLname'].$details['BillAddr'].$details['BillCity'].$details['BillZip'].
    $details['BillCountry'].$details['BillEmail'].$details['BillPhone'].$languageCode.$_SERVER['REMOTE_ADDR'].$stamp.$vendor_password);
    
    $post_variables=array(
    "first_name"=>$details['BillFname'],
    "last_name"=>$details['BillLname'],
    "email"=>$details['BillEmail'],
    "street"=>$details['BillAddr'],
    "city"=>$details['BillCity'],
    "post_code"=>$details['BillZip'],
    "country"=>$details['BillCountry'],
    "phone"=>$details['BillPhone'],
    "pos_id"=>$vendor_name,
    "pos_auth_key"=>$vendor_password2,
    "session_id"=>$details['order_id'],
    "amount"=>$amount,
    "desc"=>$PaymentDescription,
    "client_ip"=>$_SERVER['REMOTE_ADDR'],
    "js"=>'0',
    "ts"=>$stamp,
    "sig"=>$sig,
    "language"=>$languageCode
    );
    
    $pmb_button='Redirecting to payment page';
    
    $html = '<html><head><title>Redirection</title></head><body><div style="margin: auto; text-align: center;">';
		$html.= "\n".'<form name="PMBfrm" id="PMBfrm" action="https://www.platnosci.pl/paygw/UTF/NewPayment" method="post">';
	  foreach ($post_variables as $name => $value) {
			$html .= '
      <input type="hidden" name="' . $name . '" value="' . htmlspecialchars ($value) . '" />';
		}
		$html.= '<input type="submit"  value="'.$pmb_button.'" />';
		$html.= '</form></div>';
		$html.= ' <script type="text/javascript">';
    $html.= ' document.forms[\'PMBfrm\'].js.value=1;';
		$html.= ' document.PMBfrm.submit();';
		$html.= ' </script></body></html>';
    
    ob_end_clean();
    
    echo $html;exit;
  }
}
?>